/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev;

public abstract class TimedUpdater
extends Thread {
    private final long delay;
    private transient boolean stop;
    private transient boolean paused;

    public abstract void update();

    public TimedUpdater(double d) {
        this(null, d);
    }

    public TimedUpdater(String string, double d) {
        this.setName(string == null ? "TimedUpdater" : string);
        this.delay = (long)(1.0E9 / d);
    }

    public final void shutdown() {
        this.stop = true;
        this.interrupt();
    }

    public final void setPaused(boolean bl) {
        if (this.paused != bl) {
            this.paused = bl;
            if (!bl) {
                this.interrupt();
            }
        }
    }

    public final void run() {
        try {
            long l = System.nanoTime();
            while (!this.stop) {
                if (this.isPaused()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                long l2 = this.delay - (System.nanoTime() - l);
                if (l2 > 1000000L) {
                    try {
                        Thread.sleep(l2 / 1000000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    l += this.delay;
                    if (this.stop) continue;
                    this.update();
                    continue;
                }
                if (l2 >= 0L) continue;
                l = System.nanoTime();
            }
        }
        finally {
            this.updaterCompleted();
        }
    }

    public void updaterCompleted() {
    }

    public boolean isPaused() {
        return this.paused;
    }
}

